
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Handle special control chars	;
; from keyboard (online).	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ctlkey:
	php
	sep	#0x20
	cmp	#CR		; cr ?
	bne	$xon		; br if no, check XON/XOFF.
	bsl	putchr		; yes, send it.
	bit	<nlmode		; new line mode set ?
	bpl	$done		; br if no.
	lda	#LF		; yes, send lf also.
$almos:	bsl	putchr
$done:	plp
	rts
$xon:
	bit	<xonena		; auto xon enabled ?
	bpl	$almos		; br if no, don't care about XON/XOFF.
;
; sync XON/XOFF with noscroll key.
;
	cmp	#XON
	bne	$1
	lda	#0x20
	trb	<lckout		; XON, exit noscroll mode.
	plp
	rts
$1:	cmp	#XOFF
	bne	$almos		; not XON/XOFF, just echo.
	lda	#0x20
	tsb	<lckout		; XOFF, set noscroll mode.
$2:	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Handle non-ASCII key (online);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

spkey:
	php
	rep	#0x30
	phx
	phy
	sep	#0x30
	tax

;
; See what kind of key it is, jump
; to appropriate routine.
;
	sec
	sbc	#0xf1		; code for pf1
	bcs	$pf		; br if cursor/pf.
	brl	$altkey		; br if not cursor/pf key.

;
; Here to do cursor/pf key.
;
$pf:
	tax
	lda	#ESC
	bsl	putchr
	txa

	cmp	#4
	bcc	$curkey

;
; Here for pf1 .. pf4, x = 5..8
;
	bit	<vtmode		; ANSI or VT52 ?
	bpl	$pf52		; br if 52.
	lda	#'O'
	bsl	putchr
$pf52:
	txa
	clc
	adc	#'P'-5		; map x to PQRS
	brl	$almos		; send char and return.
;
; Here for cursor key, x = 0..3
;
$curkey:
	bit	<vtmode		; ANSI or VT52 ?
	bpl	$cur52		; br if 52.
	lda	#'['		; assume cursor key mode reset.
	bit	<akmode		; cursor key mode set ?
	bvc	$cur1		; br if reset.
	lda	#'O'
$cur1:	bsl	putchr
$cur52:
	txa
	bit	#2		; map 0123 to ABDC (yuk).
	beq	$cur53
	eor	#1
$cur53:	clc
	adc	#'A'		; map x to ABCD.
	brl	$almos		; send terminator and return.

;
; Here on break or alt keypad keys - code in x.
;

$altkey:

	phb			; save dbr

	phk			; set up to search table of
	plb			; alt key codes.
	per	$altmap	

	ldy	#0
	lda	(1,s),y		; get index of last table element.
	tay
	txa			; get key code.
$loop:
	cmp	(1,s),y		; find key code in table ?
	beq	$found		; br if yes.
	dey			; nope,point to next.
	dey
	dey
	bne	$loop		; 
;
; fell through, must be a break key.
;
	
$found:
	dey			; assume application mode.
	bit	<akmode
	bmi	$app		; br if application.
	dey
	lda	(1,s),y
	tax
	
	pla
	pla
	plb

	txa
	cmp	#CR		; CR ?
	bne	$alt1		; br if no.
	bit	<nlmode		; newline mode set ?
	bpl	$alt1		; br if no.
	bsl	putchr		; yes, send CR and LF.
	lda	#LF
$alt1:	brl	$almos

$app:
	lda	(1,s),y
	tax
	
	pla			; remove table addr from stack.
	pla
	plb			; restore dbr.

	lda	#ESC
	bsl	putchr
	lda	#'O'
	bit	<vtmode		; ANSI or VT52 ?
	bmi	$alt100		; br if ANSI.
	lda	#'?'
$alt100:
	bsl	putchr
	txa
$almos:	bsl	putchr
	rep	#0x30
	ply
	plx
	plp
	rts
			

$altmap:
	dcb	$lstalt-$altmap

	dcs	",l"
	dcb	0xd3

	dcs	"-m"
	dcb	0xe4

	dcs	".n"
	dcb	0xb2

	dcs	"0p"
	dcb	0xb1

	dcs	"1q"
	dcb	0xc0

	dcs	"2r"
	dcb	0xc1

	dcs	"3s"
	dcb	0xc2

	dcs	"4t"
	dcb	0xd0

	dcs	"5u"
	dcb	0xd1

	dcs	"6v"
	dcb	0xd2

	dcs	"7w"
	dcb	0xe1

	dcs	"8x"
	dcb	0xe2

	dcs	"9y"
	dcb	0xe3

	dcs	"\rM"
$lstalt:
	dcb	0xc3


	end
